/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.SceFontInfoBW;
import jpcsp.format.PGF;

public class BWFont
extends PGF {
    private byte[] fontData;
    public static final int charBitmapWidth = 16;
    public static final int charBitmapHeight = 18;
    public static final int charBitmapBytes = 36;
    private static final int[] bwCharmapCompressed = new int[]{164, 1, 167, 2, 176, 2, 183, 1, 215, 1, 224, 2, 232, 3, 236, 2, 242, 2, 247, 1, 249, 2, 252, 1, 257, 1, 275, 1, 283, 1, 299, 1, 324, 1, 328, 1, 333, 1, 363, 1, 462, 1, 464, 1, 466, 1, 468, 1, 470, 1, 472, 1, 474, 1, 476, 1, 593, 1, 609, 1, 711, 1, 713, 3, 729, 1, 913, 17, 931, 7, 945, 17, 963, 7, 1025, 1, 1040, 64, 1105, 1, 8208, 1, 8211, 4, 8216, 2, 8220, 2, 8229, 2, 8240, 1, 8242, 2, 8245, 1, 8251, 1, 8364, 1, 8451, 1, 8453, 1, 8457, 1, 8470, 1, 8481, 1, 8544, 12, 8560, 10, 8592, 4, 8598, 4, 8712, 1, 8719, 1, 8721, 1, 8725, 1, 8730, 1, 8733, 4, 8739, 1, 8741, 1, 8743, 5, 8750, 1, 8756, 4, 8765, 1, 8776, 1, 8780, 1, 8786, 1, 8800, 2, 8804, 4, 8814, 2, 8853, 1, 8857, 1, 8869, 1, 8895, 1, 8978, 1, 9312, 10, 9332, 40, 9472, 76, 9552, 36, 9601, 15, 9619, 3, 9632, 2, 9650, 2, 9660, 2, 9670, 2, 9675, 1, 9678, 2, 9698, 4, 9733, 2, 9737, 1, 9792, 1, 9794, 1, 11905, 1, 11908, 1, 11912, 1, 11915, 2, 11927, 1, 11943, 1, 11946, 1, 11950, 1, 11955, 1, 11958, 2, 11963, 1, 11978, 1, 12272, 12, 12288, 4, 12293, 19, 12317, 2, 12321, 9, 12350, 1, 12353, 83, 12443, 4, 12449, 86, 12540, 3, 12549, 37, 12832, 10, 12849, 1, 12963, 1, 13198, 2, 13212, 3, 13217, 1, 13252, 1, 13262, 1, 13265, 2, 13269, 1, 13312, 6582, 19968, 20902, 59277, 10, 59335, 2, 59414, 3, 59422, 1, 59430, 1, 59435, 2, 59441, 2, 59451, 1, 59459, 1, 59476, 2, 59492, 1, 63788, 1, 63865, 1, 63893, 1, 63975, 1, 63985, 1, 64012, 4, 64017, 1, 64019, 2, 64024, 1, 64031, 3, 64035, 2, 64039, 3, 65072, 2, 65075, 18, 65097, 10, 65108, 4, 65113, 14, 65128, 4, 65281, 94, 65504, 6};

    public BWFont(ByteBuffer f, String fileName) throws IOException {
        this.read(f, fileName);
    }

    private void read(ByteBuffer f, String fileName) {
        this.fontData = new byte[f.capacity()];
        f.get(this.fontData);
        this.firstGlyph = bwCharmapCompressed[0];
        this.lastGlyph = bwCharmapCompressed[bwCharmapCompressed.length - 2] + bwCharmapCompressed[bwCharmapCompressed.length - 1] - 1;
        this.maxSize[0] = 1024;
        this.maxSize[1] = 1152;
        this.maxAdvance[0] = 1024;
        this.maxAdvance[1] = 1152;
        this.fontName = fileName;
        this.fontType = fileName;
    }

    public byte[] getFontData() {
        return this.fontData;
    }

    public int[] getCharmapCompressed() {
        return bwCharmapCompressed;
    }

    @Override
    public SceFontInfo createFontInfo() {
        return new SceFontInfoBW(this);
    }
}

